/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import util.Config;

public class Logger {
    private final String Logfilename = "JDFCorr.log";
    private static boolean exists = false;
    private static Logger theLog = null;
    private SimpleDateFormat myTimeFormat;
    private FileWriter fw;
    private String indent;
    private int maxLogLevel;

    public int getLogLevel() {
        return this.maxLogLevel;
    }

    public void setLogLevel(int n) {
        this.maxLogLevel = n;
    }

    private Logger() {
        Config cfg = Config.getConfig();
        try {
            this.fw = new FileWriter("JDFCorr.log");
            this.myTimeFormat = new SimpleDateFormat("HH:mm:ss:SSS");
            this.indent = " ";
            this.maxLogLevel = cfg.getParamToInt("LogLevel");
            exists = true;
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    public static Logger getLogger() {
        if (!exists) {
            theLog = new Logger();
        }
        return theLog;
    }

    public void log(int level, String logStr) {
        if (level <= this.maxLogLevel) {
            try {
                this.fw.write(String.valueOf(this.getTimeString()) + this.indent + logStr + "\n");
                this.fw.flush();
            }
            catch (IOException ex) {
                System.out.println(ex);
            }
        }
    }

    public void entry(int level, String logStr) {
        if (level <= this.maxLogLevel) {
            try {
                this.fw.write(String.valueOf(this.getTimeString()) + this.indent + "entry " + logStr + "\n");
                this.fw.flush();
                this.indent = String.valueOf(this.indent) + "  ";
            }
            catch (IOException ex) {
                System.out.println(ex);
            }
        }
    }

    public void exit(int level, String logStr) {
        if (level <= this.maxLogLevel) {
            try {
                if (this.indent.length() > 1) {
                    this.indent = this.indent.substring(2);
                }
                this.fw.write(String.valueOf(this.getTimeString()) + this.indent + "exit  " + logStr + "\n");
                this.fw.flush();
            }
            catch (IOException ex) {
                System.out.println(ex);
            }
        }
    }

    private String getTimeString() {
        Date d = new Date();
        return this.myTimeFormat.format(d);
    }
}

